/**
  ******************************************************************************
  * @file    iwdg_interface.c
  * @author  MCD Application Team
  * @brief   Contains IWDG HW configuration
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor Co.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by Puya under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "platform.h"
#include "iwdg_interface.h"
#include "openbl_core.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
static IWDG_HandleTypeDef IWDGHandle;

/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/

void OPENBL_IWDG_Configuration(void)
{
  IWDGHandle.Instance       = IWDG;
  IWDGHandle.Init.Prescaler = IWDG_PRESCALER_256;
  IWDGHandle.Init.Reload    = IWDG_KEY_RELOAD;

  /* In case the user has enabled the IWDG through HW before entering the Open Bootloader */
  IWDG->KR = IWDG_KEY_WRITE_ACCESS_ENABLE;
  IWDG->PR = IWDG_PRESCALER_256;
  IWDG->KR = IWDG_KEY_RELOAD;
}

void OPENBL_IWDG_Refresh(void)
{
  /* Refresh IWDG: reload counter */
  HAL_IWDG_Refresh(&IWDGHandle);
}

static const OPENBL_OpsTypeDef IWDG_Ops =
{
  .Init = OPENBL_IWDG_Configuration,
  .DeInit = NULL,
  .Detection = NULL,
  .CommandProcess = NULL,
};

static const OPENBL_IOTypeDef IWDG_IO =
{
  .Read = NULL,
  .Write = NULL,
};

OPENBL_HandleTypeDef IWDG_Handle =
{
  .p_Ops = &IWDG_Ops,
  .p_IO = &IWDG_IO,
};

/************************ (C) COPYRIGHT Puya *****END OF FILE****/
